<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.asyntai (Unified for Joomla 3/4/5)
 * @copyright   (C) Asyntai
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Base class shim so one codepath works on J3 and J4/5
if (class_exists('Joomla\\CMS\\Plugin\\CMSPlugin')) {
    class AsyntaiBasePlugin extends Joomla\CMS\Plugin\CMSPlugin {}
} else {
    jimport('joomla.plugin.plugin');
    class AsyntaiBasePlugin extends JPlugin {}
}

class PlgSystemAsyntai extends AsyntaiBasePlugin
{
    /** @var mixed */
    protected $app;

    public function onAfterRender()
    {
        if ($this->isAdminClient()) {
            if ($this->isOwnPluginEditPage()) {
                $this->maybeHandleAdminReset();
                $this->injectAdminIframeAndStatus();
            }
            return;
        }

        $siteId = trim((string) $this->params->get('site_id', ''));
        if ($siteId === '') {
            return;
        }

        $scriptUrl = trim((string) $this->params->get('script_url', 'https://asyntai.com/static/js/chat-widget.js'));

        $buffer = $this->getBody();
        $inject = '<script type="text/javascript">(function(){var s=document.createElement("script");s.async=true;s.defer=true;s.src=' . json_encode($scriptUrl) . ';s.setAttribute("data-asyntai-id",' . json_encode($siteId) . ');s.charset="UTF-8";var f=document.getElementsByTagName("script")[0];if(f&&f.parentNode){f.parentNode.insertBefore(s,f);}else{document.head.appendChild(s);}})();</script>';

        if (strpos($buffer, '</body>') !== false) {
            $buffer = str_replace('</body>', $inject . '</body>', $buffer);
        } else {
            $buffer .= $inject;
        }
        $this->setBody($buffer);
    }

    private function injectAdminIframeAndStatus()
    {
        $buffer = $this->getBody();

        $siteId = trim((string) $this->params->get('site_id', ''));
        $accountEmail = trim((string) $this->params->get('account_email', ''));

        $expectedOrigin = 'https://asyntai.com';
        $iframeSrc = $expectedOrigin . '/wp-auth?platform=joomla';

        $statusHtml = '';
        if ($siteId !== '') {
            $statusHtml = '<div id="asyntai-status" style="margin:10px 0;">'
                . 'Status: <span style="color:#008a20;">Connected</span>'
                . ($accountEmail ? (' as ' . htmlspecialchars($accountEmail, ENT_QUOTES)) : '')
                . ' <a class="btn btn-small btn-secondary" style="margin-left:8px;" href="' . htmlspecialchars($this->getResetUrl(), ENT_QUOTES) . '">Reset</a>'
                . '</div>';
        } else {
            $statusHtml = '<div id="asyntai-status" style="margin:10px 0;">'
                . 'Status: <span style="color:#a00;">Not connected</span>'
                . '</div>';
        }

        $connectedBox = '<div id="asyntai-connected-box" style="display:' . ($siteId ? 'block' : 'none') . ';">'
            . '<div style="max-width:820px;margin:20px auto;padding:20px;border:1px solid #ddd;border-radius:8px;background:#fff;text-align:center;">'
            . '<div style="font-size:20px;font-weight:700;margin-bottom:8px;">Asyntai is now enabled</div>'
            . '<div style="font-size:16px;margin-bottom:16px;">Set up your AI chatbot, review chat logs and more:</div>'
            . '<a class="btn btn-primary" href="https://asyntai.com/dashboard" target="_blank" rel="noopener">Open Asyntai Panel</a>'
            . '</div>'
            . '</div>';

        $iframeWrap = '<div id="asyntai-iframe-wrap" style="display:' . ($siteId ? 'none' : 'block') . ';background:#fff;border:1px solid #ddd;border-radius:8px;overflow:hidden;">'
            . '<div style="padding:24px;text-align:center;">'
            . '<div style="font-size:18px;margin-bottom:12px;">Create an Asyntai account or sign in to enable the chatbot</div>'
            . '<button id="asyntai-connect-btn" class="btn btn-primary">Get started</button>'
            . '<div style="margin-top:12px;color:#666;">If a popup is blocked, <a href="' . htmlspecialchars($iframeSrc, ENT_QUOTES) . '" target="_blank" rel="noopener">open the connect window</a>.</div>'
            . '</div>'
            . '</div>';

        $alert = '<div id="asyntai-alert" class="alert" style="display:none;margin-top:10px;"></div>';

        $saveUrl = $this->getRoot() . 'index.php?option=com_ajax&plugin=asyntai&format=json&group=system&task=save';
        $resetUrl = $this->getResetUrl();
        $inlineJs = '<script>(function(){function showAlert(msg, ok){var el=document.getElementById("asyntai-alert");if(!el)return;el.style.display="block";el.className="alert "+(ok?"alert-success":"alert-danger");el.textContent=msg;}function openPopup(){var state="joomla_"+Math.random().toString(36).substr(2,9);var url=' . json_encode($iframeSrc) . '+"&state="+state;var w=800,h=720;var y=window.top.outerHeight/2+window.top.screenY - (h/2);var x=window.top.outerWidth/2+window.top.screenX - (w/2);var pop=window.open(url,"asyntai_connect","toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width="+w+",height="+h+",top="+y+",left="+x);if(!pop){showAlert("Popup blocked. Please allow popups or use the link below.",false);return;}pollForConnection(state);}function pollForConnection(state){var attempts=0;function check(){if(attempts++>60)return;var script=document.createElement("script");var cb="asyntai_cb_"+Date.now();script.src="https://asyntai.com/connect-status.js?state="+encodeURIComponent(state)+"&cb="+cb;window[cb]=function(data){if(data&&data.site_id){showAlert("Asyntai connected. Saving…",true);fetch(' . json_encode($saveUrl) . ',{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({site_id:data.site_id||"",script_url:data.script_url||"",account_email:data.account_email||""})}).then(function(r){if(!r.ok)throw new Error("HTTP "+r.status);return r.json()}).then(function(){showAlert("Asyntai connected. Chatbot enabled on all pages.",true);var status=document.getElementById("asyntai-status");if(status){var html="Status: <span style=\\"color:#008a20;\\">Connected</span>";if(data.account_email){html+=" as "+data.account_email+" <a class=\\"btn btn-small btn-secondary\\" style=\\"margin-left:8px;\\" href=\\"' . htmlspecialchars($resetUrl, ENT_QUOTES) . '\\">Reset</a>";}status.innerHTML=html;}var box=document.getElementById("asyntai-connected-box");if(box)box.style.display="block";var wrap=document.getElementById("asyntai-iframe-wrap");if(wrap)wrap.style.display="none";}).catch(function(err){showAlert("Could not save settings: "+(err&&err.message||err),false)});return;}setTimeout(check,500);};document.head.appendChild(script);}setTimeout(check,1000);}document.addEventListener("click",function(ev){var t=ev.target;if(t&&t.id==="asyntai-connect-btn"){ev.preventDefault();openPopup();}});})();</script>';

        $injection = '<div class="container" id="asyntai-admin-wrap">' . $statusHtml . $alert . $connectedBox . $iframeWrap . $inlineJs . '</div>';

        // Preferred: place after description paragraph before the closing </div>
        $descSnippet = '<p>Asyntai - AI Chatbot</p>';
        $descPos = strpos($buffer, $descSnippet);
        if ($descPos !== false) {
            $afterDesc = $descPos + strlen($descSnippet);
            // Look for the next </div> after the description
            $divClose = strpos($buffer, '</div>', $afterDesc);
            if ($divClose !== false) {
                $buffer = substr($buffer, 0, $divClose) . $injection . substr($buffer, $divClose);
                $this->setBody($buffer);
                return;
            }
        }

        // Fallback: after page title (J3 behavior)
        if (preg_match('/<h1[^>]*>.*?<\\/h1>/is', $buffer, $mh1, PREG_OFFSET_CAPTURE)) {
            $h1End = $mh1[0][1] + strlen($mh1[0][0]);
            $buffer = substr($buffer, 0, $h1End) . $injection . substr($buffer, $h1End);
            $this->setBody($buffer);
            return;
        }

        // Final fallback: bottom injection
        if (strpos($buffer, '</body>') !== false) {
            $buffer = str_replace('</body>', $injection . '</body>', $buffer);
        } else {
            $buffer .= $injection;
        }
        $this->setBody($buffer);
    }

    private function maybeHandleAdminReset()
    {
        $input = $this->getInput();
        if (!$input) {
            return; // No input available, skip reset check
        }
        if ((int) $input->getInt('reset') === 1) {
            $this->saveParams(array('site_id' => '', 'script_url' => '', 'account_email' => ''));
            $uri = $this->getUri();
            if (method_exists($uri, 'delVar')) { $uri->delVar('reset'); }
            $this->redirect((string) $uri);
        }
    }

    private function isOwnPluginEditPage()
    {
        $input = $this->getInput();
        if (!$input) {
            return false; // No input available, can't determine page
        }
        $option = $input->getCmd('option');
        $view = $input->getCmd('view');
        if ($option !== 'com_plugins' || $view !== 'plugin') {
            return false;
        }
        $extensionId = (int) $input->getInt('extension_id', 0);
        if (!$extensionId) {
            $extensionId = (int) $input->getInt('eid', 0);
        }
        if (!$extensionId) {
            return false;
        }
        $db = $this->getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(array('element', 'folder')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('extension_id') . ' = ' . (int) $extensionId);
        $db->setQuery($query);
        $row = $db->loadObject();
        return $row && $row->element === 'asyntai' && $row->folder === 'system';
    }

    public function onAjaxAsyntaiSave()
    {
        $this->handleAjaxSave();
    }

    public function onAjaxAsyntai()
    {
        $this->handleAjaxSave();
    }

    private function handleAjaxSave()
    {
        $raw = file_get_contents('php://input');
        $data = json_decode($raw, true);
        if (!is_array($data)) {
            $data = array();
        }
        $siteId = isset($data['site_id']) ? trim((string) $data['site_id']) : '';
        $scriptUrl = isset($data['script_url']) ? trim((string) $data['script_url']) : '';
        $accountEmail = isset($data['account_email']) ? trim((string) $data['account_email']) : '';
        if ($siteId === '') {
            $this->sendJson(array('success' => false, 'error' => 'missing site_id'), 400);
            return;
        }
        $payload = array('site_id' => $siteId);
        if ($scriptUrl !== '') {
            $payload['script_url'] = $scriptUrl;
        }
        if ($accountEmail !== '') {
            $payload['account_email'] = $accountEmail;
        }
        $this->saveParams($payload);
        $this->sendJson(array('success' => true));
    }

    private function saveParams(array $changes)
    {
        $db = $this->getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(array('extension_id', 'params')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('asyntai'))
            ->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
            ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
            ->setLimit(1);
        $db->setQuery($query);
        $row = $db->loadObject();
        if (!$row) {
            return;
        }
        $extensionId = (int) $row->extension_id;
        $current = array();
        if (!empty($row->params)) {
            $decoded = json_decode($row->params, true);
            if (is_array($decoded)) {
                $current = $decoded;
            }
        }
        foreach ($changes as $k => $v) {
            $current[$k] = $v;
        }
        $paramsJson = json_encode($current);
        $upd = $db->getQuery(true)
            ->update($db->quoteName('#__extensions'))
            ->set($db->quoteName('params') . ' = ' . $db->quote($paramsJson))
            ->where($db->quoteName('extension_id') . ' = ' . (int) $extensionId);
        $db->setQuery($upd);
        try { $db->execute(); } catch (Exception $e) {}
    }

    private function sendJson(array $data, $status = 200)
    {
        if (function_exists('http_response_code')) {
            @http_response_code((int) $status);
        }
        header('Content-Type: application/json');
        echo json_encode($data);
        if (class_exists('JFactory')) {
            JFactory::getApplication()->close();
        } elseif (class_exists('Joomla\\CMS\\Factory')) {
            Joomla\CMS\Factory::getApplication()->close();
        }
    }

    // ---- Helpers (Cross-version) ----

    private function isAdminClient()
    {
        if (method_exists($this->app, 'isClient')) {
            return $this->app->isClient('administrator');
        }
        if (method_exists($this->app, 'isAdmin')) {
            return $this->app->isAdmin();
        }
        return false;
    }

    private function getInput()
    {
        // J4/5/6: Check app and input are both available
        if (method_exists($this->app, 'input') && $this->app && $this->app->input) {
            return $this->app->input;
        }
        // J6 fallback: Try Factory directly if app->input is null
        if (class_exists('Joomla\\CMS\\Factory')) {
            try {
                $app = Joomla\CMS\Factory::getApplication();
                if ($app && $app->input) {
                    return $app->input;
                }
            } catch (Exception $e) {
                // Continue to J3 fallback
            }
        }
        // J3 fallback
        if (class_exists('JFactory')) {
            try {
                $app = JFactory::getApplication();
                if ($app && $app->input) {
                    return $app->input;
                }
            } catch (Exception $e) {
                // Input not available
            }
        }
        return null;
    }

    private function getDbo()
    {
        if (class_exists('Joomla\\CMS\\Factory')) {
            return Joomla\CMS\Factory::getDbo();
        }
        return JFactory::getDbo();
    }

    private function getUri()
    {
        if (class_exists('Joomla\\CMS\\Uri\\Uri')) {
            return Joomla\CMS\Uri\Uri::getInstance();
        }
        return JUri::getInstance();
    }

    private function getRoot()
    {
        if (class_exists('Joomla\\CMS\\Uri\\Uri')) {
            return Joomla\CMS\Uri\Uri::root();
        }
        return JUri::root();
    }

    private function redirect($url)
    {
        if (method_exists($this->app, 'redirect')) {
            $this->app->redirect($url);
            return;
        }
        if (class_exists('JFactory')) {
            JFactory::getApplication()->redirect($url);
        }
    }

    private function getBody()
    {
        if (method_exists($this->app, 'getBody')) {
            return (string) $this->app->getBody();
        }
        if (class_exists('JResponse')) {
            return (string) JResponse::getBody();
        }
        return '';
    }

    private function setBody($buffer)
    {
        if (method_exists($this->app, 'setBody')) {
            $this->app->setBody($buffer);
            return;
        }
        if (class_exists('JResponse')) {
            JResponse::setBody($buffer);
        }
    }

    private function getResetUrl()
    {
        $uri = $this->getUri();
        if (method_exists($uri, 'setVar')) {
            $uri->setVar('reset', '1');
        }
        return (string) $uri;
    }
}
